import { cn } from "@/utlis";
import Image from "next/image";

const Loading = () => {
  return (
    <div className="mx-auto flex h-screen w-screen max-w-full flex-col items-center justify-center gap-5 overflow-hidden">
      <Image
        src="/images/icons/logo.svg"
        alt="hero-image"
        loading="eager"
        width={300}
        height={400}
        className={cn(
          "transition-all duration-1000 ease-in-out w-48 md:w-[300px]",
          "animate-float"
        )}
      />
    </div>
  );
};

export default Loading;
